string GetDescription()
{
	return "Renders the harmony into a track with simple chords";
}

void PlaceNextChord(RenderPart @p, Time t1)
{
	int harm = 	p.GetHarmonic(t1);
	
	for (int f = 0; f < p.GetHarmonicComponents(harm); f++)
	{
		int pit = p.ComputePitch(p.GetHarmonicEventPitch(harm, f));
		
		while (pit > 70)
			pit -= 12;	
			
		while (pit < 48)
			pit += 12;	
					
		Time end = t1;
		end.m_Pos += RndFloat(0.12, 0.18);
		p.AddPercNote(t1, end, pit ,RndInt(85,95));	
	}
}

void Render(RenderPart @p)
{
	double step = 1.0;
	if (p.GetTempo() < 70) step /= 2.0;
	
	for (int i = p.GetStartBar(); i < p.GetEndBar(); i++)
	{
		if (i % 2 == 1 && RndInt(0,1) == 0)
		{
			for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
			{
				if (m > 0) PlaceNextChord(p, CreateTime(i, m));
				PlaceNextChord(p, CreateTime(i, m+ step * 4.0 / 6.0));
				
				if (RndInt(0,1) == 0 && m + step < p.GetUniquePart().GetMetrum()) PlaceNextChord(p, CreateTime(i, m+ step * 8.0 / 6.0));
			}
		}
		else
		{
			for (double m = 0; m < p.GetUniquePart().GetMetrum(); m+=step)
			{
				PlaceNextChord(p, CreateTime(i, m+ step * 4.0 / 6.0));
			}
		}
	}
}